----------------
title : C++ 레퍼런스 - string 의 c_str 함수
cat_title : c_str
ref_title : c_str, std::c_str
path : /C++ Reference/string
publish_date : 2019-09-19
----------------

##@ cpp-ref-start

#@ c_str

```cpp-formatted
const CharT* c_str() const noexcept;  // C++ 11 부터
```

문자열 객체에 저장된 문자열들과 같은 내용을 담고 있는 **널 종료 문자 배열** 을 가리키는 포인터를 리턴한다.

쉽게 말해서 `c_str()` 부터 `c_str() + size()` 전 까지 우리의 문자열이 저장되어 있고, 맨 마지막 위치에는 `NULL` 문자가 오게 됩니다. `string` 객체를 널 종료 문자 배열을 받는 함수에 전달할 때 유용하게 사용할 수 있습니다.

참고로 아래와 같은 작업을 수행하면 `c_str()` 함수에서 리턴된 포인터가 더이상 유효하지 않습니다.

* 표준 라이브러리 함수에 `const` 가 아닌 레퍼런스를 전달했을 때
* `const` 가 아닌 멤버 함수를 호출하였을 때. 이 때 `operator[]`, `at`, `front`, `back`, `begin`, `rbegin`, `end`, `rend` 제외.

참고로 `c_str()` 이 리턴하는 **배열을 수정하는 것은 정의되지 않는 작업 (undefined behavior) 입니다!**

### 인자들

없음

### 리턴값

문자열 배열의 시작 주소값

### 실행 예제

```cpp-formatted
#include <algorithm>
#include <cassert>
#include <cstring>
#include <string>

int main() {
  std::string const s("Emplary");
  assert(s.size() == std::strlen(s.c_str()));
  assert(std::equal(s.begin(), s.end(), s.c_str()));
  assert(std::equal(s.c_str(), s.c_str() + s.size(), s.begin()));
  assert(0 == *(s.c_str() + s.size()));
}
```

```exec

```

### 참고 자료

* `front` : 첫 번째 문자를 얻는다.
* `back` : 마지막 문자를 얻는다.
* `data` : 첫 번째 문자를 가리키는 포인터를 얻는다. (C++ 11 부터 `c_str` 과 `data` 는 같은 역할을 한다.)